<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Administration extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
	}

	public function index()
	{
		if(!$this->admins_model->get_admin_by_random_string()){
			redirect('admin/login', 'refresh');
		}
		$this->load->view('admin/admin_view');
	}

	public function clear_ci_sessions()
	{
		$this->db->query('Delete From ci_sessions Where timestamp < ?',array(time()-7200));
	}

	public function delete_old_labels()
	{
		if(!$this->session->userdata('admin_id')){redirect('admin/login', 'refresh');}

		$locales = $this->db->get('locales')->result_array();
		foreach($locales as $locale)
		{
			if(file_exists('./application/language/'.$locale['locale_path'].'/site_lang.php'))
			{
				unlink('./application/language/'.$locale['locale_path'].'/site_lang.php');
			}
		}
		$result['success'] = TRUE;
		echo json_encode($result);
	}

	public function auto_draw_winners($token,$contest='')
	{
		// exit();
		$date = date('Y-m-d');
		if($token=='4EFjMaGM')
		{
			switch($contest)
			{
				case 'sklavenitis2023':
					if($date == '2023-07-10')
					{
						$contest_new = $contest.'-pikap-lenco';
						$this->_draw_winners($contest,$contest_new,'2023-06-15 08:00:00','2023-06-29',10);
						$this->_draw_epilaxontes($contest,$contest_new,'2023-06-15 08:00:00','2023-06-29',10);
						//$this->_send_draw_email($contest,$contest_new);

						$contest_new = $contest.'-akoustika-jbl';
						$this->_draw_winners($contest,$contest_new,'2023-06-15 08:00:00','2023-06-29',30);
						$this->_draw_epilaxontes($contest,$contest_new,'2023-06-15 08:00:00','2023-06-29',30);
						//$this->_send_draw_email($contest,$contest_new);
					}
					else
					{
						echo 'Wrong draw date for: '.$contest;
					}
				break;
				case 'mymarket2023':
					if($date == '2023-06-29')
					{
						$contest_new = $contest.'-partybox-jbl';
						$this->_draw_winners($contest,$contest_new,'2023-06-14 08:00:00','2023-06-27',5);
						$this->_draw_epilaxontes($contest,$contest_new,'2023-06-14 08:00:00','2023-06-27',5);
						$this->_send_draw_email($contest,$contest_new);

						$contest_new = $contest.'-bluetooth-jbl-go3';
						$this->_draw_winners($contest,$contest_new,'2023-06-14 08:00:00','2023-06-27',10);
						$this->_draw_epilaxontes($contest,$contest_new,'2023-06-14 08:00:00','2023-06-27',10);
						$this->_send_draw_email($contest,$contest_new);
					}
					else
					{
						echo 'Wrong draw date for: '.$contest;
					}
				break;
			}
		}
	}

	private function _draw_winners($main_contest,$contest,$min_date,$max_date,$limit)
	{
		$emails   = array();
		$phones   = array();
		$winners  = $this->db->query('Select id From winners Where contest = ?',array($contest))->result_array();
		if(sizeof($winners)==0)
		{
			$all_winners = $this->db->query('Select email,phone From winners')->result_array();
			for($i=0;$i<sizeof($all_winners);$i++)
			{
				if($all_winners[$i]['email'])
				{
					$emails[] = $all_winners[$i]['email'];
				}
				$phones[] = $all_winners[$i]['phone'];
			}

			$csv = fopen($_SERVER['DOCUMENT_ROOT'].'/winners_'.$contest.'.csv','w');
			fputcsv($csv,array('Firstname','Lastname','Email','Phone'));

			$i             = 0;
			$winners_drawn = 0;
			$sql           = 'Select * From contestants Where contest = ? And created_at >= "'.$min_date.'" And created_at <= "'.$max_date.'" Order by RAND()';
			$contestants   = $this->db->query($sql,array($main_contest))->result_array();
			while($winners_drawn < $limit)
			{
				if(!in_array($contestants[$i]['email'],$emails,TRUE) && !in_array($contestants[$i]['phone'],$phones,TRUE))
				{
					$winners_drawn++;
					if($contestants[$i]['email'])
					{
						$emails[] = $contestants[$i]['email'];
					}
					$phones[] = $contestants[$i]['phone'];

					$winner = array(
						'contest'       => $contest,
						'contestant_id' => $contestants[$i]['id'],
						'firstname'     => $contestants[$i]['firstname'],
						'lastname'      => $contestants[$i]['lastname'],
						'email'         => $contestants[$i]['email'],
						'phone'         => $contestants[$i]['phone']
					);
					$this->db->insert('winners',$winner);
					fputcsv($csv,array($winner['firstname'],$winner['lastname'],$winner['email'],$winner['phone']));
				}
				$i++;
			}
			fclose($csv);
			$message = 'Winners created for contest:'.$contest;
		}
		else
		{
			$message = 'Winners already created for contest:'.$contest;
		}
		return $message;
	}

	private function _draw_epilaxontes($main_contest,$contest,$min_date,$max_date,$limit)
	{
		$emails   = array();
		$phones   = array();
		$epilaxontes  = $this->db->query('Select id From epilaxontes Where contest = ?',array($contest))->result_array();
		if(sizeof($epilaxontes)==0)
		{
			$all_winners     = $this->db->query('Select email,phone From winners')->result_array();
			for($i=0;$i<sizeof($all_winners);$i++)
			{
				if($all_winners[$i]['email'])
				{
					$emails[] = $all_winners[$i]['email'];
				}
				$phones[] = $all_winners[$i]['phone'];
			}
			$all_epilaxontes = $this->db->query('Select email,phone From epilaxontes')->result_array();
			for($i=0;$i<sizeof($all_epilaxontes);$i++)
			{
				if($all_epilaxontes[$i]['email'])
				{
					$emails[] = $all_epilaxontes[$i]['email'];
				}
				$phones[] = $all_epilaxontes[$i]['phone'];
			}

			$csv = fopen($_SERVER['DOCUMENT_ROOT'].'/epilaxontes_'.$contest.'.csv','w');
			fputcsv($csv,array('Firstname','Lastname','Email','Phone'));

			$i                 = 0;
			$epilaxontes_drawn = 0;
			$sql               = 'Select * From contestants Where contest = ? And created_at >= "'.$min_date.'" And created_at <= "'.$max_date.'" Order by RAND()';
			$contestants       = $this->db->query($sql,array($main_contest))->result_array();
			while($epilaxontes_drawn < $limit)
			{
				if(!in_array($contestants[$i]['email'],$emails,TRUE) && !in_array($contestants[$i]['phone'],$phones,TRUE))
				{
					$epilaxontes_drawn++;
					if($contestants[$i]['email'])
					{
						$emails[] = $contestants[$i]['email'];
					}
					$phones[] = $contestants[$i]['phone'];

					$epilaxontas = array(
						'contest'       => $contest,
						'contestant_id' => $contestants[$i]['id'],
						'firstname'     => $contestants[$i]['firstname'],
						'lastname'      => $contestants[$i]['lastname'],
						'email'         => $contestants[$i]['email'],
						'phone'         => $contestants[$i]['phone']
					);
					$this->db->insert('epilaxontes',$epilaxontas);
					fputcsv($csv,array($epilaxontas['firstname'],$epilaxontas['lastname'],$epilaxontas['email'],$epilaxontas['phone']));
				}
				$i++;
			}
			fclose($csv);
			$message = 'Epilaxontes created for contest:'.$contest;
		}
		else
		{
			$message = 'Epilaxontes already created for contest:'.$contest;
		}
		return $message;
	}

	private function _send_draw_email($main_contest,$contest)
	{
		$from = 'john@webflow.gr';
		$to   = $this->config->item('email_send_winners_'.$main_contest);

		$this->email->clear(TRUE);
		$this->email->from($from);
		$this->email->to($to);
		$this->email->attach('./winners_'.$contest.'.csv');
		$this->email->attach('./epilaxontes_'.$contest.'.csv');
		$this->email->subject('Amstel Contest Winners: '.$contest);
		$this->email->send();
		return $this->email->print_debugger();
	}
}
/* End of file administration.php */
/* Location: ./system/application/controllers/administration.php */