<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Forms extends CI_Controller {
		
	public function browse($table,$table_id)
	{
		if(!$this->admin_auth->has_access($table,'browse')){
			message_handler(FALSE,'Access Denied','');
		}
		
		$id    = $this->input->get('id',TRUE);
		$query = $this->db->query('Select * from '.$table.' Where '.$table_id.' = ?',array($id));

		$result['success'] = true;
		$result['data']    = $query->row_array();		
		echo json_encode($result);
	}
	
	public function browse_texts($table,$table_id)
	{
		if(!$this->admin_auth->has_access($table,'browse')){
			message_handler(FALSE,'Access Denied','');
		}
		
		$id     = $this->input->get('id',TRUE);
		$locale = $this->input->get('locale',TRUE);
		$query  = $this->db->query('Select * from '.$table.' Where '.$table_id.' = ? And locale = ?',array($id,$locale));

		$result['success'] = true;
		$result['data']    = $query->row_array();		
		echo json_encode($result);
	}
	
	public function submit($table,$table_id)
	{
		if(!$this->admin_auth->has_access($table,'edit')){
			message_handler(FALSE,'Access Denied','');
		}
		
		$fields = array();
		$values = array();
		
		$id         = $this->input->post('id',TRUE);
		$parameters = $this->input->post('parameters',TRUE);
		if($parameters)
		{
			$parameters = explode(',',$parameters);

			foreach($parameters as $p)
			{
				if($this->input->post($p)!==FALSE)
				{
					$fields[] = $p." = ? ";
					$value = $this->input->post($p);
					if($value=='on'){$value=1;}
					if($value=='off'){$value=0;}
					$values[] = $value;	
				}
			}
			if(sizeof($values)>0)
			{
				$values[] = $id;

				$this->db->query('Update '.$table.' set '.join(',',$fields).' Where '.$table_id.' = ? ',$values);
				$result['debug'] = $this->db->last_query();
			}
		}
		
		$query = $this->db->query('Select * from '.$table.' Where '.$table_id.' = ?',array($id));
		$result['data'] = $query->row_array();	
		$result['success'] = true;
		$result['csrf_token'] = $this->security->get_csrf_hash();
		
		echo json_encode($result);
	}
	
	public function submit_texts($table,$table_id)
	{
		if(!$this->admin_auth->has_access($table,'edit')){
			message_handler(FALSE,'Access Denied','');
		}
		
		$fields = array();
		$values = array();
		
		$id         = $this->input->post('id',TRUE);
		$title      = $this->input->post('content_text_title',TRUE);
		$slug       = $this->input->post('content_text_slug',TRUE);
		$locale     = $this->input->post('locale',TRUE);
		$parameters = $this->input->post('parameters',TRUE);

		if($parameters)
		{
			$parameters = explode(',',$parameters);
			if($slug)
			{
				$fields[] = " content_text_slug = ? ";
				$values[] = fix_slug($slug);
			}
			if($title)
			{
				if(!$slug)
				{
					$fields[] = " content_text_slug = ? ";
					$values[] = fix_slug($title);
				}
			}
		
			foreach($parameters as $p)
			{
				if($p!='content_text_slug')
				{
					if($this->input->post($p)!==FALSE)
					{
						$fields[] = $p." = ? ";
						$value = $this->input->post($p);
						if($value=='on'){$value=1;}
						if($value=='off'){$value=0;}
						$values[] = $value;	
					}
				}
			}
			if(sizeof($values)>0)
			{
				$values[] = (int)$id;
				$values[] = $locale;
			
				$this->db->query('Update '.$table.' set '.join(',',$fields).' Where '.$table_id.' = ? And locale = ? ',$values);
				$result['debug'] = $this->db->last_query();
			}
		}
		
		$query = $this->db->query('Select * from '.$table.' Where '.$table_id.' = ? And locale = ?',array($id,$locale));
		$result['success'] = true;
		$result['csrf_token'] = $this->security->get_csrf_hash();
		$result['data'] = $query->row_array();		
		echo json_encode($result);
	}
	
	public function browse_multilingual($table,$texts_table,$table_id)
	{
		if(!$this->admin_auth->has_access($table,'browse')){
			message_handler(FALSE,'Access Denied','');
		}
		
		$id    = $this->input->get('id',TRUE);
		$query = $this->db->query('Select * from '.$table.' Where '.$table_id.' = ?',array($id));

		$result['success'] = true;
		$result['data']    = $query->row_array();
		
		$query = $this->db->query('Select * From locales');
		$locales = $query->result_array();
		foreach($locales as $l){
			$query = $this->db->query('Select * from '.$texts_table.' Where '.$table_id.' = ? And locale = ?',array($id,$l['locale_code']));
			$result['data'][$l['locale_code']] = $query->row_array();
		}
		
		echo json_encode($result);
	}
}
/* End of file admin/forms.php */
/* Location: ./system/application/controllers/admin/forms.php */