<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Login extends CI_Controller {

	public function index()
	{
		$this->admin_auth->logout();
		$this->load->view('admin/login_view');
	}
	
	public function submit()
	{
		// if(check_recaptcha($this->input->post('g-recaptcha-response',TRUE)))
		if(TRUE)
		{
			$username = $this->input->post('loginUsername',TRUE);
			$password = $this->input->post('loginPassword',TRUE);

			$result = $this->admins_model->login($username,$password);
		}
		else
		{
			$result = array(
				'success'  => FALSE
				,'message' => 'Recaptcha Error.'
			);
		}
		echo json_encode($result);
	}
	
	public function signout()
	{
		$this->admin_auth->logout();
		$this->load->view('admin/login_view');
	}

	public function info()
	{
		$result = array(
			'success'        => TRUE,
			'admin_id'       => $this->session->admin_id,
            'username'       => $this->session->username,
            'modules'        => $this->session->modules,
            'random_string'  => $this->session->random_string,
            'csrf_hash'      => $this->security->get_csrf_hash(),
            'is_super_admin' => $this->session->is_super_admin
		);
		echo json_encode($result);
	}
}
/* End of file admin/login.php */
/* Location: ./system/application/controllers/admin/login.php */