<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if ( ! function_exists('generate_random_string'))
{
	function generate_random_string($length=10) 
	{
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, strlen($characters) - 1)];
		}
		return $randomString;
	}	
}

if ( ! function_exists('my_mb_ucfirst'))
{
	function my_mb_ucfirst($str)
	{
	    $fc = mb_strtoupper(mb_substr($str, 0, 1));
	    return $fc.mb_substr($str, 1);
	}	
}	

if ( ! function_exists('gr_to_en'))
{
	function gr_to_en($string)
	{
		$greek   = array('α','ά','β','γ','δ','ε','έ','ζ','η','ή','θ','ι','ί','ϊ','κ','λ','μ','ν','ξ','ο','ό','π','ρ','σ','ς','τ','υ','ϋ','ύ','φ','χ','ψ','ω','ώ',' ','/','&','"',"'",',','.',':','(',')','«','»',';','!','%');
		$english = array('a','a','v','g','d','e','e','z','i','i','th','i','i','i','k','l','m','n','x','o','o','p','r','s','s','t','u','u','u','f','x','ps','o','o','-','-','','','','','','','','','','','','','');
		return str_replace($greek, $english, mb_strtolower($string));
	}	
}

if ( ! function_exists('month_name1'))
{
	function month_name1($locale,$index)
	{
		if($locale=='gr'){
			$months = array('Ιανουάριος','Φεβρουάριος','Μάρτιος','Απρίλιος','Μάιος','Ιούνιος','Ιούλιος','Αύγουστος','Σεπτέμβριος','Οκτώβριος','Νοέμβριος','Δεκέμβριος');
		} else {
			$months = array('January','February','March','April','May','June','July','August','September','October','November','December');
		}
		return $months[$index-1];
	}	
}

if ( ! function_exists('month_name2'))
{
	function month_name2($locale,$index)
	{
		if($locale=='gr'){
			$months = array('Ιανουαρίου','Φεβρουαρίου','Μαρτίου','Απριλίου','Μαΐου','Ιουνίου','Ιουλίου','Αυγούστου','Σεπτεμβρίου','Οκτωβρίου','Νοεμβρίου','Δεκεμβρίου');
		} else {
			$months = array('January','February','March','April','May','June','July','August','September','October','November','December');
		}
		return $months[$index-1];
	}	
}

if ( ! function_exists('blog_unfilter_date'))
{
	function blog_unfilter_date($locale,$month_year)
	{
		if($locale=='gr'){
			$months = array('','Ιανουάριος','Φεβρουάριος','Μάρτιος','Απρίλιος','Μάιος','Ιούνιος','Ιούλιος','Αύγουστος','Σεπτέμβριος','Οκτώβριος','Νοέμβριος','Δεκέμβριος');
		} else {
			$months = array('','January','February','March','April','May','June','July','August','September','October','November','December');
		}
		$month_year = urldecode($month_year);
		$dates      = explode('-',$month_year);
		$result     = array(
			'value' => ''
			,'text' => ''
		);
		
		if(sizeof($dates)==2)
		{
			$result     = array(
				'value' => str_pad(array_search(my_mb_ucfirst($dates[0]),$months),2,'0',STR_PAD_LEFT).' '.$dates[1]
				,'text' => my_mb_ucfirst(str_replace('-',' ',$month_year))
			);
		}
		return $result;
	}	
}

if ( ! function_exists('blog_filter_date'))
{
	function blog_filter_date($locale,$month_year)
	{
		$result = '';
		$dates  = explode(' ',$month_year);
		if(sizeof($dates)==2)
		{
			$result = month_name1($locale,$dates[0]).' '.$dates[1];
		}
        return $result;
	}	
}

if ( ! function_exists('blog_date'))
{
	function blog_date($locale,$datetime)
	{
		$time = strtotime($datetime);
		return date('j',$time).' '.month_name2($locale,date('n',$time)).' '.date('Y',$time);
	}	
}

if ( ! function_exists('fix_slug'))
{
	function fix_slug($string,$id=0)
	{
		$slug        = mb_strtolower(strip_tags($string));
		$has_final_s = mb_strpos($slug,'σ',mb_strlen($slug)-1);

		if($has_final_s){
			$slug = rtrim($slug,'σ').'ς';
		}

		$slug = str_replace(array(' ','/','&','"',"'",',','.',':','(',')','«','»',';','!','%'), array('-','-','','','','','','','','','','','','',''),$slug);

		while(mb_strpos($slug,'--') !== FALSE || mb_strpos($slug,'σ-') !== FALSE){
			$slug = str_replace(array('--','σ-'),array('-','ς-'),$slug);
		}

		if($id){
			$slug .= '-'.$id;
		}
		return urlencode($slug);
	}	
}

if ( ! function_exists('paging_html'))
{
	function paging_html($total_pages,$page)
	{
		$paging_html  = '';
		if($total_pages>1)
		{
			$class        = $page==1? 'class="btn--link disabled" style="visibility:hidden;"' : 'class="btn--link"';
			$paging_html .= '<span class="nav"><a href="#" '.$class.' data-page="1"><i class="fa-long-arrow-left"></i> '.lang('previous_page').'</a></span>';
			$paging_html .= '<ul>';
			for($i=1;$i<=$total_pages;$i++)
			{
				$class        = $i==$page? 'class="current"' : '';
				$paging_html .= '<li '.$class.'><button data-page="'.$i.'">'.$i.'</button></li>';
			}
			$paging_html .= '</ul>';
			$class        = ($page==$total_pages)? 'class="btn--link disabled" style="visibility:hidden;"' : 'class="btn--link"';
			$paging_html .= '<span class="nav"><a href="#" '.$class.' data-page="'.($page+1).'">'.lang('next_page').' <i class="fa-long-arrow-right"></i></span>';
		}
		return $paging_html;
	}	
}


if ( ! function_exists('create_friendly_url'))
{
	function create_friendly_url($locale,$content_type_description,$content_id=0,$external_url="",$hashtag="")
	{
		$CI =& get_instance();
		switch($content_type_description)
		{
			case 'Home Page':
				$link = site_url('home');
			break;
			case 'External Url':
				$link = $external_url;
			break;
			default:
				$link = base_url();
			break;
		}
		if($hashtag)
		{
			$link .= '#'.$hashtag;
		}
		return $link;
	}	
}

if ( ! function_exists('check_recaptcha'))
{
	function check_recaptcha($response) 
	{
		$CI         =& get_instance();
		$curl_handle = curl_init();
	    curl_setopt($curl_handle, CURLOPT_URL, 'https://www.google.com/recaptcha/api/siteverify');
	    curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
	    curl_setopt($curl_handle, CURLOPT_POST, 1);
	    curl_setopt($curl_handle, CURLOPT_POSTFIELDS, array(
	        'secret'    => $CI->config->item('recaptcha_secret_key')
	        ,'response' => $response
	    ));
	     
	    $buffer = curl_exec($curl_handle);
	    curl_close($curl_handle);
	     
	    $result = json_decode($buffer);
	    return $result->success;
	}
}

if ( ! function_exists('fix_page_title'))
{
	function fix_page_title($text,$default) 
	{
		$page_title = $default? $default.' | '.$text : $text;
		return strip_tags($page_title);
	}
}

if ( ! function_exists('fix_page_description'))
{
	function fix_page_description($text,$default) 
	{
		$page_description = $text? $text : $default;
		return strip_tags($page_description);
	}
}

/* End of file website_helper.php */
/* Location: ./system/helpers/website_helper.php */
