function createContestantsGrid(){

	var store = new Ext.data.JsonStore({
		autoLoad: true
		,remoteSort: true
		,url: base_url+admin_folder+'tables/browse/contestants'
		,method: 'post'
		,baseParams: {
			start: 0
			,limit: 100
		}
		,sortInfo: {
		    field: 'created_at'
		    ,direction: 'DESC'
		}
		,root: 'data'
		,totalProperty: 'total'
	    ,successProperty: 'success'
	    ,idProperty: 'id'
		,fields: [
			{name: 'id'}
			,{name: 'contest'}
			,{name: 'firstname'}
			,{name: 'lastname'}
			,{name: 'email'}
			,{name: 'phone'}
			,{name: 'created_at', type: 'date', dateFormat: 'Y-m-d H:i:s'}
			,{name: 'is_allowed_age', type:'boolean'}
			,{name: 'is_accept_terms', type:'boolean'}
		]
	});

	var filters = new Ext.ux.grid.GridFilters({
		encode: true
		,local: false
		,filters: [
			{
				type: 'string'
				,dataIndex: 'contest'
			}
			,{
				type: 'string'
				,dataIndex: 'firstname'
			}
			,{
				type: 'string'
				,dataIndex: 'lastname'
			}
			,{
				type: 'string'
				,dataIndex: 'email'
			}
			,{
				type: 'string'
				,dataIndex: 'phone'
			}
			,{
				type: 'date'
				,dataIndex: 'created_at'
			}
			,{
				type: 'boolean'
				,dataIndex: 'is_allowed_age'
			}
			,{
				type: 'boolean'
				,dataIndex: 'is_accept_terms'
			}
		]
	});

	var columns =  [
		{header: "Contest", sortable: true, dataIndex: 'contest'}
		,{header: "Firstname", sortable: true, dataIndex: 'firstname'}
		,{header: "Lastname", sortable: true, dataIndex: 'lastname'}
		,{header: "Email", sortable: true, dataIndex: 'email'}
		,{header: "Phone", sortable: true, dataIndex: 'phone'}
		,{header: "Created", sortable: true, dataIndex: 'created_at', renderer:Ext.util.Format.dateRenderer2}
		// ,{header: "Legal Age", sortable: true, dataIndex: 'is_allowed_age'}
		// ,{header: "Accept Terms", sortable: true, dataIndex: 'is_accept_terms'}
	];

	var paging = new Ext.PagingToolbar({
		pageSize: 100
		,store: store
		,displayInfo: true
		,displayMsg: '{0} - {1} from {2}'
		,emptyMsg: 'No results found'
	});

	var grid = new Ext.grid.GridPanel({
		id: 'contestantsGrid'
		,title: 'Contestants'
		,frame: false
		,autoScroll: true
		,closable: true
		,iconCls:'group'
		,plugins: [filters]
		,store: store
		,columns: columns
		,viewConfig: {
			forceFit: true
		}
		,bbar: paging
	});

	adminContentPanel = Ext.getCmp('adminContentPanel');
	adminContentPanel.add(grid);
	adminContentPanel.doLayout();
	adminContentPanel.getLayout().setActiveItem(grid);
	return false;
}