function createLabelsGrid(){

	var tBar = new Ext.Toolbar({});
	var adminActions = [];
	var index = adminAccessStore.findExact('module','labels');
	var moduleActions = adminAccessStore.getAt(index);

	if(is_super_admin || moduleActions.data.module_actions.indexOf('edit') != -1){
		adminActions.push({
			iconCls:'edit'
			,qtip:'EDIT'
		});
		tBar.add({
			text:'Refresh Site Labels'
			,tooltip:'Refresh Site Labels'
			,iconCls:'refresh'
			,listeners:{
				click:{scope:this, buffer:200, fn:function(btn) {
					deleteOldLabels();
				}}
			}
		});
	}

	if(is_super_admin || moduleActions.data.module_actions.indexOf('delete') != -1){
		adminActions.push({
			iconCls:'delete'
			,qtip:'DELETE'
		});
	}
	
	if(is_super_admin || moduleActions.data.module_actions.indexOf('insert') != -1){
		tBar.add({
			text:'Add'
			,tooltip:'Add'
			,iconCls:'add'
			,listeners:{
				click:{scope:this, buffer:200, fn:function(btn) {
					form.show(addRecord(grid,emptyRecord), btn.getEl());
				}}
			}
		});
	}
	
	var form = new Ext.ux.grid.RecordForm({
		 title:'EDIT'
		,iconCls:'edit'
		,columnCount:1
		,ignoreFields:{
			label_id:true
			,main_image:true
		}
		,formConfig:{
			 labelWidth:150
			,buttonAlign:'right'
			,bodyStyle:'padding-top:10px'
		}
	});

	var proxy = new Ext.data.HttpProxy({
		method: "POST"	
		,api: {
			read:     base_url+admin_folder+'tables/browse/labels'
			,create:  base_url+admin_folder+'tables/create_locale/labels/label_id/label_texts/'+admin_locale
			,update:  base_url+admin_folder+'tables/update/labels/label_id'
			,destroy: base_url+admin_folder+'tables/delete_locale/labels/label_id/label_texts'
		}
	});

	var reader = new Ext.data.JsonReader({
		totalProperty: 'total'
		,successProperty: 'success'
		,idProperty: 'label_id'
		,root: 'data'
	},[
		{name: 'label_id'}
		,{name: 'label_name'}
		,{name: 'main_image'}
		,{name: 'label_description'}
	]);

	var emptyRecord = {
		label_name: ''
		,main_image: ''
		,label_description: ''
	};

	var writer = new Ext.data.JsonWriter({
		encode: true
		,writeAllFields: false
	});

	var store = new Ext.data.Store({
		paramsAsHash: true
		,remoteSort: true
		,proxy: proxy
		,reader: reader
		,writer: writer
		,baseParams: {
			start:0
			,limit:100
		}
		,sortInfo: {
		    field: 'label_name'
		    ,direction: 'ASC'
		}
		,autoLoad: true
		,autoSave: true
		,listeners: {
	        exception: function (proxy, response, operation) {
                // adminLogout();
                Ext.Msg.alert('Status','Connectivity Problem!');
            }
	    }
	});

	var actions = new Ext.ux.grid.RowActions({
		actions: adminActions
		,widthIntercept:Ext.isSafari ? 4 : 2
		,getEditor:Ext.emptyFn
	});

	var filters = new Ext.ux.grid.GridFilters({
		local: true
		,filters: [
			{
				type: 'string'
				,dataIndex: 'label_name'
			},
			{
				type: 'string'
				,dataIndex: 'label_description'
			}
		]
	});

	var columns =  [
		// {header: "Image", sortable: true, dataIndex: 'main_image', renderer:Ext.util.Format.imageRenderer}
		{header: "Name", sortable: true, dataIndex: 'label_name', editor: new Ext.form.TextField({})}
		,{header: "Description", sortable: true, dataIndex: 'label_description', editor: new Ext.form.TextField({})}
		,actions
	];

	var paging = new Ext.PagingToolbar({
		pageSize: 100
		,store: store
		,displayInfo: true
		,displayMsg: '{0} - {1} from {2}'
		,emptyMsg: 'No results found'
	});

	var grid = new Ext.grid.GridPanel({
		id: 'labelsGrid'
		,title: 'Site Labels'
		,iconCls: 'font'
		,frame: false
		,autoScroll: true
		,closable: true
		,plugins: [actions, form, filters]
		,store: store
		,columns : columns
		,tbar: tBar
		,viewConfig: {
			forceFit: true
		}
		,bbar: paging
		,onRowAction:function(grid, record, action, row, col) {
			switch(action) {
				case 'delete':
					deleteRecord(grid,record);
				break;
				case 'edit':
					createLabelsForm(record.data.label_id,record.data.label_name);
				break;
			}
		}
	});

	actions.on('action', grid.onRowAction, grid);
	
	adminContentPanel = Ext.getCmp('adminContentPanel');
	adminContentPanel.add(grid);
	adminContentPanel.doLayout();
	adminContentPanel.getLayout().setActiveItem(grid);
	return false;	
}