function createSettingsForm(settingId,settingName){

	var form = new Ext.FormPanel({
		title: 'Basic'
		,autoHeight: true
		,border: false
		,labelWidth: 150
		,flex: 1
		,margins: '0 5 0 0'
		,url: base_url+admin_folder+'forms/submit/settings/setting_id/'
		,items: [
			{
				xtype: 'hidden'
				,name: 'id'
				,value: settingId
			}
			,{
				xtype: 'hidden'
				,name: 'parameters'
				,value: 'setting_name,setting_value'
			}
			,{
				xtype: 'textfield'
				,style: 'margin-top:5px;'
				,fieldLabel: 'Name'
				,anchor: '100%'
				,name: 'setting_name'
			}
			,{
				xtype: 'textarea'
				,fieldLabel: 'Value'
				,anchor: '100%'
				,height: 500
				,name: 'setting_value'
			}
		]
    });

	form.load({
		url: base_url+admin_folder+'forms/browse/settings/setting_id/'
		,params: {id:settingId}
        ,method:'GET'
        ,waitMsg:'Loading'
	});

	var panel = new Ext.Panel({
		id: 'settingPanel_'+settingId
		,title: 'Edit Setting: '+settingName
		,iconCls: 'cog'
		,closable: true
		,border: false
		,layout: 'fit'
		,bodyStyle: 'padding:5px;'
		,items: [form]
		,buttons:[
			{
				text: 'Save'
				,handler: function (){
					form.getForm().submit();
					Ext.Msg.alert('Status','Succesful save!');
				}
			}
		]
		,listeners: {
			beforeclose: function(p){}
		}
	});

	adminContentPanel = Ext.getCmp('adminContentPanel');
	adminContentPanel.add(panel);
	adminContentPanel.doLayout();
	adminContentPanel.getLayout().setActiveItem(panel);
	return false;
}