var localesStore = new Ext.data.JsonStore({
	id: 'localesStore'
	,url: base_url+admin_folder+'tables/browse/locales'
	,method: 'post'
	,root: 'data'
	,idProperty: 'locale_id'
	,sortInfo: {
	    field: 'sequence'
	    ,direction: 'ASC'
	}
	,fields: [
		'locale_id'
		,'locale_code'
		,'locale_description'
	]
	,autoLoad:true
	,remoteSort:true
});

var adminAccessStore = new Ext.data.JsonStore({
	id: 'adminAccessStore'
	,url: base_url+admin_folder+'tables/browse/admin_access'
	,method: 'post'
	,baseParams: {
		custom_field: 'admin_id'
		,custom_value: admin_id
	}
	,root: 'data'
	,idProperty: 'admin_access_id'
	,fields: [
		'admin_access_id'
		,'admin_id'
		,'module'
		,'module_actions'
	]
	,autoLoad:true
});

var filesStore = new Ext.data.JsonStore({
	url: base_url+admin_folder+'tables/browse/files'
	,method: 'POST'
	,baseParams: {
		custom_field: 'is_image'
		,custom_value: 0
		,select_fields: 'file_id,file_name'
	}
	,sortInfo: {
	    field: 'created_at'
	    ,direction: 'DESC'
	}
	,root: 'data'
	,totalProperty: 'total'
	,successProperty: 'success'
	,idProperty: 'file_id'
	,fields: 
	[
		{name: 'file_id'}
		,{name: 'file_name'}
		,{name: 'created_at', type:'date', dateFormat:'Y-m-d H:i:s'}
	]
	,autoLoad: true
	,remoteSort: true
});
