function createAdminAccessGrid(adminId){

	var modulesCombo = new Ext.form.ComboBox({
		fieldLabel: 'Access'
		,name: 'module'
		,hiddenName: 'module'
		,hideOnSelect: false
		,anchor: '100%'
		,store: modulesStore
		,triggerAction: 'all'
		,valueField: 'module'
		,displayField: 'module_description'
		,mode: 'local'
	});

	myMοduleActions = [
		['browse','BROWSE']
		,['insert','INSERT']
		,['edit','EDIT']
		,['delete','DELETE']
	];

	var mοduleActionsStore = new Ext.data.ArrayStore({
		idIndex: 0
		,data: myMοduleActions
	    ,fields: [
	    	'module_action'
			,'module_action_description'
	    ]
	});

	var moduleActionsCombo = new Ext.ux.form.LovCombo({
		fieldLabel: 'Actions'
		,name: 'module_actions'
		,hiddenName: 'module_actions'
		,anchor: '100%'
		,hideOnSelect: false
		,store: mοduleActionsStore
		,triggerAction: 'all'
		,valueField: 'module_action'
		,displayField: 'module_action_description'
		,mode: 'local'
	});
	
	var form = new Ext.ux.grid.RecordForm({
		 title:'EDIT'
		,iconCls:'edit'
		,columnCount:1
		,ignoreFields:{
			admin_access_id:true
			,admin_id:true
		}
		,formConfig:{
			 labelWidth:150
			,buttonAlign:'right'
			,bodyStyle:'padding-top:10px'
		}
	});

	var proxy = new Ext.data.HttpProxy({
		method: "POST"
		,api: {
			read :    base_url+admin_folder+'tables/browse/admin_access'
			,create : base_url+admin_folder+'tables/create/admin_access/admin_access_id'
			,update:  base_url+admin_folder+'tables/update/admin_access/admin_access_id'
			,destroy: base_url+admin_folder+'tables/destroy/admin_access/admin_access_id'
		}
	});

	var reader = new Ext.data.JsonReader({
		totalProperty: 'total'
		,successProperty: 'success'
		,idProperty: 'admin_access_id'
		,root: 'data'
	},[
		{name: 'admin_access_id'}
		,{name: 'admin_id'}
		,{name: 'module'}
		,{name: 'module_actions'}
	]);

	var emptyRecord = {
		admin_id: adminId
		,module: ''
		,module_actions: 'browse'
	};

	var writer = new Ext.data.JsonWriter({
		encode: true
		,writeAllFields: false
	});

	var store = new Ext.data.Store({
		paramsAsHash: true
		,remoteSort: true
		,proxy: proxy
		,reader: reader
		,writer: writer
		,baseParams: {
			start:0
			,limit:100
			,custom_field: 'admin_id'
			,custom_value: adminId
		}
		,autoLoad: true
		,autoSave: true
		,listeners: {
			update : function( store, record, operation) {
				adminAccessStore.reload();
			}
	        ,exception: function (proxy, response, operation) {
                // adminLogout();
                Ext.Msg.alert('Status','Connectivity Problem!');
            }
	    }
	});

	var actions = new Ext.ux.grid.RowActions({
		 actions:[{
			 iconCls:'delete'
			,qtip:'DELETE'
		},{
			 iconCls:'edit'
			,qtip:'EDIT'
		}]
		,widthIntercept:Ext.isSafari ? 4 : 2
		,getEditor:Ext.emptyFn
	});

	var columns =  [
		{header: "Access", dataIndex: 'module', editor: modulesCombo, renderer:Ext.util.Format.comboRenderer(modulesCombo)}
		,{header: "Actions", dataIndex: 'module_actions', editor: moduleActionsCombo, renderer:Ext.util.Format.multiComboRenderer(moduleActionsCombo)}
		,actions
	];

	var paging = new Ext.PagingToolbar({
		pageSize: 100
		,store: store
		,displayInfo: true
		,displayMsg: '{0} - {1} from {2}'
		,emptyMsg: 'No results found'
	});

	var grid = new Ext.grid.GridPanel({
		id: 'adminAccessGrid'+adminId
		,title: 'Administrator Access'
		,frame: false
		,autoScroll: true
		,closable: true
		,iconCls:'admin'
		,plugins: [actions, form]
		,store: store
		,columns : columns
		,sm: new Ext.grid.RowSelectionModel({
			singleSelect: true
		})
		,tbar: [{
			 text:'Add'
			,tooltip:'Add'
			,iconCls:'add'
			,listeners:{
				click:{scope:this, buffer:200, fn:function(btn) {
					form.show(addRecord(grid,emptyRecord), btn.getEl());
				}}
			}
		}]
		,viewConfig: {
			forceFit: true
		}
		,bbar: paging
		,onRowAction:function(grid, record, action, row, col) {
			switch(action) {
				case 'delete':
					deleteRecord(grid,record);
				break;
				case 'edit':
					form.show(record, grid.getView().getCell(row, col));
				break;
			}
		}
	});

	actions.on('action', grid.onRowAction, grid);
	
	adminContentPanel = Ext.getCmp('adminContentPanel');
	adminContentPanel.add(grid);
	adminContentPanel.doLayout();
	adminContentPanel.getLayout().setActiveItem(grid);
	return false;
}