/****************************************************
* CKEditor Extension
*****************************************************/
Ext.form.CKEditor = function(config){
    this.config = config;
    Ext.form.CKEditor.superclass.constructor.call(this, config);
};

Ext.extend(Ext.form.CKEditor, Ext.form.TextArea,  {
    onRender : function(ct, position){
        if(!this.el){
            this.defaultAutoCreate = {
                tag: "textarea",
                autocomplete: "off"
            };
        }
        Ext.form.TextArea.superclass.onRender.call(this, ct, position);
	   if (CKEDITOR.instances[this.id]) {
            delete CKEDITOR.instances[this.id];
        }
	   CKEDITOR.replace(this.id, this.config.CKConfig);
    },
    setValue : function(value){
        Ext.form.TextArea.superclass.setValue.apply(this,[value]);
        if (CKEDITOR.instances[this.id]) {
            CKEDITOR.instances[this.id].setData( value );
        }
    },
    getValue : function(){
        if (CKEDITOR.instances[this.id]) {
            CKEDITOR.instances[this.id].updateElement();
        }
		return Ext.form.TextArea.superclass.getValue(this);
    },
    insertHtml: function(value){
		//this.ckel = CKEDITOR.dom.element.createFromHtml(value);
		CKEDITOR.instances[this.id].config.forceSimpleAmpersand = true;
		CKEDITOR.instances[this.id].insertHtml( value );
		CKEDITOR.instances[this.id].config.forceSimpleAmpersand=false;
    },
    getRawValue : function(){
        if (CKEDITOR.instances[this.id]) {
            CKEDITOR.instances[this.id].updateElement();
        }	
		return Ext.form.TextArea.superclass.getRawValue(this);
    },
    destroyInstance: function(){
        if (CKEDITOR.instances[this.id]) {
            delete CKEDITOR.instances[this.id];
        }
    } 
});
Ext.reg('ckeditor', Ext.form.CKEditor);