<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Contest extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
	}

	public function index()
	{
		$this->lang->load('site');

		$locale = 'gr';
		$slug   = $this->uri->segment(2,0);

		$data['meta']  = lang('meta_'.$slug)? lang('meta_'.$slug) : lang('meta_default');
		$data['id']    = lang('id_'.$slug)? lang('id_'.$slug) : '';
		$data['html']  = '';
		$data['html'] .= lang('header_'.$slug)? lang('header_'.$slug) : lang('header_default');
		$data['html'] .= lang('content_'.$slug)? lang('content_'.$slug) : '';

		$this->load->view('website/page',$data);
	}

	public function accept_terms()
	{
		$this->lang->load('site');

		$value = $this->input->get('value');
		$this->session->set_userdata('accept_terms',$value);
	}

	public function submit()
	{
		$this->lang->load('site');

		$locale     = 'gr';
		// $recaptcha  = check_recaptcha($this->input->post('g-recaptcha-response',TRUE));
		$recaptcha  = TRUE;
		$data       = array(
			'contest'          => strip_tags($this->input->post('contest',TRUE))
			,'firstname'       => strip_tags($this->input->post('firstname',TRUE))
			,'lastname'        => strip_tags($this->input->post('lastname',TRUE))
			,'email'           => strip_tags($this->input->post('email',TRUE))
			,'phone'           => strip_tags($this->input->post('phone',TRUE))
			// ,'is_allowed_age'  => $this->input->post('allowed_age',TRUE)? 1 : 0
			,'is_accept_terms' => $this->input->post('accept_terms',TRUE)? 1 : 0
	    	,'created_at'      => date('Y-m-d H:i:s')
		);
		
		$date_check = strtotime($data['created_at']);
		switch ($data['contest']) {
			case 'sklavenitis':
				$date_from = strtotime('2022-07-07 08:00:00');
				$date_to   = strtotime('2022-07-22 00:00:00');
			break;
			case 'mymarket':
				$date_from = strtotime('2022-07-06 08:00:00');
				$date_to   = strtotime('2022-07-20 00:00:00');
			break;
			case 'sklavenitis2023':
				$date_from = strtotime('2023-06-15 08:00:00');
				$date_to   = strtotime('2023-06-30 00:00:00');
			break;
			case 'mymarket2023':
				$date_from = strtotime('2023-06-14 08:00:00');
				$date_to   = strtotime('2023-06-28 00:00:00');
			break;
		}

		if($date_check < $date_from)
		{
			$result = array(
				'success'  => FALSE
				,'message' => lang('error_contest_not_started')
				,'wait'    => 0
			);
		}
		else
		{
			if($date_check >= $date_to)
			{
				$result = array(
					'success'  => FALSE
					,'message' => lang('error_contest_ended')
					,'wait'    => 0
				);
			}
			else
			{
				$this->form_validation->set_rules('firstname', 'lang:field_firstname', 'required');
				$this->form_validation->set_rules('lastname', 'lang:field_lastname', 'required');
				$this->form_validation->set_rules('email', 'lang:field_email', 'required|valid_email');
				$this->form_validation->set_rules('phone', 'lang:field_phone', 'required');
				// $this->form_validation->set_rules('allowed_age',  '', 'required', array('required' => lang('error_allowed_age')));
				$this->form_validation->set_rules('accept_terms', '', 'required', array('required' => lang('error_accept_terms')));

				if(!$recaptcha)
				{
					$result = array(
						'success'  => FALSE
						,'message' => lang('error_recaptcha')
						,'wait'    => 0
					);
				}
				else
				{
					if($this->form_validation->run() == FALSE)
					{
						// $result = array(
						// 	'success'  => FALSE
						// 	,'message' => validation_errors()
						// 	,'wait'    => 0
						// );

						$field_errors = array(
							array('name' => 'firstname', 'text' => form_error('firstname')),
							array('name' => 'lastname', 'text' => form_error('lastname')),
							array('name' => 'email', 'text' => form_error('email')),
							array('name' => 'phone', 'text' => form_error('phone')),
							array('name' => 'accept_terms', 'text' => form_error('accept_terms'))
						);
						$result = array(
							'success'       => FALSE
							,'field_errors' => $field_errors
							,'wait'         => 0
						);
					} 
					else 
					{
						$existing = $this->db->query('Select id From contestants Where contest = ? And (phone = ? OR email = ?) And DATE(created_at) = ?',array($data['contest'],$data['phone'],$data['email'],date('Y-m-d')))->row_array();
						if(sizeof($existing)>0)
						{
							$result = array(
								'success'  => FALSE
								,'message' => lang('error_already_played')
								,'wait'    => 0
							);
						}
						else
						{
							$this->db->insert('contestants',$data);
						    $result = array(
								'success'  => TRUE
								,'message' => lang('success_played')
								,'wait'    => 4000
							);
						}
					}
				}
			}
		}
		echo json_encode($result);
	}
}
/* End of file Contest.php */
/* Location: ./system/application/controllers/Contest.php */