<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require './application/third_party/aws/aws-autoloader.php';
use Aws\S3\S3Client;
use Aws\S3\Exception\S3Exception;

if ( ! function_exists('amazon_upload_file'))
{
	function amazon_upload_file($key,$file) 
	{
		$CI     =& get_instance();
		// $client = S3Client::factory(array(
		//     'version'      => AWS_VERSION
		//     ,'region'      => AWS_REGION
		//     ,'credentials' => array(
		//     	'key'     => AWS_KEY
		//         ,'secret' => AWS_SECRET
		//     )
		// ));
		$client = S3Client::factory(array(
		    'version'      => $CI->config->item('aws_version')
		    ,'region'      => $CI->config->item('aws_region')
		    ,'credentials' => array(
		    	'key'     => $CI->config->item('aws_key')
		        ,'secret' => $CI->config->item('aws_secret')
		    )
		));

		try {
			// $response = $client->putObject(array(
			//     'Bucket'      => AWS_BUCKET
			//     ,'Key'        => $key
			//     ,'SourceFile' => $file
			//     ,'ACL'        => 'public-read'
			// ));
			$response = $client->putObject(array(
			    'Bucket'      => $CI->config->item('aws_bucket')
			    ,'Key'        => $key
			    ,'SourceFile' => $file
			    ,'ACL'        => 'public-read'
			));

			$result = array(
				'success'    => TRUE
				,'file_name' => $key
				,'message'   => ''
			);
		} 
		catch (S3Exception $e){
			$result = array(
				'success'    => FALSE
				,'file_name' => ''
				,'message'   => $e->getMessage()
			);
		}
		return $result;
	}	
}

if ( ! function_exists('amazon_upload_image_string'))
{
	function amazon_upload_image_string($key,$string) 
	{
		$CI    =& get_instance();
		$image = imagecreatefromstring($string);
	    if(!$image)
	    {
	        return FALSE;
	    }
	    else
	    {
	    	ob_start();
	    	imagejpeg($image);
			$image_data = ob_get_clean();

			// $client = S3Client::factory(array(
			//     'version'      => AWS_VERSION
			//     ,'region'      => AWS_REGION
			//     ,'credentials' => array(
			//     	'key'     => AWS_KEY
			//         ,'secret' => AWS_SECRET
			//     )
			// ));
			$client = S3Client::factory(array(
			    'version'      => $CI->config->item('aws_version')
			    ,'region'      => $CI->config->item('aws_region')
			    ,'credentials' => array(
			    	'key'     => $CI->config->item('aws_key')
			        ,'secret' => $CI->config->item('aws_secret')
			    )
			));

			try {
				// $response = $client->putObject(array(
				//     'Bucket'       => AWS_BUCKET
				//     ,'Key'         => $key
				//     ,'Body'        => $image_data
				//     ,'ContentType' => 'image/jpeg'
				//     ,'ACL'         => 'public-read'
				// ));
				$response = $client->putObject(array(
				    'Bucket'       => $CI->config->item('aws_bucket')
				    ,'Key'         => $key
				    ,'Body'        => $image_data
				    ,'ContentType' => 'image/jpeg'
				    ,'ACL'         => 'public-read'
				));

				return TRUE;
			} 
			catch (S3Exception $e){
				return FALSE;
			}
	    }
	}	
}

if ( ! function_exists('amazon_show_image'))
{
	function amazon_show_image($key) 
	{
		$CI        =& get_instance();
		// $image_url = CLOUD_FRONT? CLOUD_FRONT.$key : AWS_ENDPOINT.$key;
		$image_url = $CI->config->item('cloud_front')? $CI->config->item('cloud_front').$key : $CI->config->item('aws_endpoint').$key; 
		return $image_url;
	}	
}

if ( ! function_exists('amazon_delete_file'))
{
	function amazon_delete_file($key) 
	{
		$CI     =& get_instance();
		// $client = new S3Client([
		//     'version'      => AWS_VERSION
		//     ,'region'      => AWS_REGION
		//     ,'credentials' => [
		//         'key'     => AWS_KEY
		//         ,'secret' => AWS_SECRET
		//     ]
		// ]);
		$client = S3Client::factory(array(
		    'version'      => $CI->config->item('aws_version')
		    ,'region'      => $CI->config->item('aws_region')
		    ,'credentials' => array(
		    	'key'     => $CI->config->item('aws_key')
		        ,'secret' => $CI->config->item('aws_secret')
		    )
		));

		// $response = $client->deleteObject(array(
		//     'Bucket' => AWS_BUCKET
		//     ,'Key'   => $key
		// ));
		$response = $client->deleteObject(array(
		    'Bucket' => $CI->config->item('aws_bucket')
		    ,'Key'   => $key
		));

		return TRUE;
	}	
}
/* End of file image_helper.php */
/* Location: ./system/helpers/image_helper.php */