<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Myhooks {

	var $CI;

	function load()
	{
		$CI =& get_instance();
		$results = $CI->db->get('settings')->result();
		
		foreach ($results as $setting)
		{
			$CI->config->set_item($setting->setting_name, $setting->setting_value);
		}
	}

	function create_lang_files()
	{
		$CI =& get_instance();
		$locales = $CI->db->get('locales')->result_array();
		foreach ($locales as $locale)
		{
			if(!file_exists('./application/language/'.$locale['locale_path'].'/site_lang.php'))
			{
				$data   = "<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');\n\n";
				$labels = $CI->db->get('labels')->result_array();
			
				foreach ($labels as $label)
				{
					$label_texts = $CI->db->get_where('label_texts', array('label_id' => $label['label_id'], 'locale' => $locale['locale_code']))->result_array();
					foreach ($label_texts as $label_text)
					{
						$data .= '$lang["'.$label['label_name'].'"] = "'.str_replace('"', '\"', $label_text['label_value']).'";'."\n";
						if($label['main_image'])
						{
							$data .= '$lang["'.$label['label_name'].'_image"] = "/assets/uploads/'.str_replace('"', '\"', $label['main_image']).'";'."\n";	
						}
					}
				}
				$file_path = './application/language/'.$locale['locale_path'].'/site_lang.php';
				write_file($file_path, $data);
			}
		}
	}

	function create_lang_const()
	{
		$CI      =& get_instance();
		$locales = $CI->db->get('locales')->result_array();

		foreach ($locales as $locale)
		{
			define('LABELS_'.mb_strtoupper($locale['locale_code']), serialize($CI->contents_model->get_labels($locale['locale_code'])));
		}
	}
}
/* End of file myhooks.php */
/* Location: ./application/hooks/myhooks.php */