function createFilesForm(fileId,fileName){

	var langTabPanel = new Ext.TabPanel({
		border: false
		,bodyStyle: 'padding:5px;'
		,deferredRender:false
		,items : []
	});

	localesStore.each(function(l)
	{
		form = new Ext.FormPanel({
			id: 'fileForm_'+fileId+'_'+l.get('locale_code')
			,title: l.get('locale_description')
			,url: base_url+admin_folder+'forms/submit_texts/file_texts/file_id/'
			,autoHeight: true
			,labelWidth: 200
			,bodyStyle: 'margin-top:5px;'
			,items:[
				{
					xtype: 'hidden'
					,name: 'id'
					,value: fileId
				}
				,{
					xtype: 'hidden'
					,name: 'locale'
					,value: l.get('locale_code')
				}
				,{
					xtype: 'hidden'
					,name: 'parameters'
					,value: 'file_title,file_body'
				}
				,{
					xtype:"textfield"
					,fieldLabel: 'Title'
					,anchor: '100%'
					,name: 'file_title'
				},
				{
					xtype: 'ckeditor'
					,fieldLabel: 'Text'
					,name: 'file_body'
					,CKConfig: {
						customConfig : '/assets/ckeditor/config.js'
						,toolbar: 'Basic'
						,contentsCss: "/assets/ckeditor/ck.css"
					}
				}
			]
	    });

	    form.load({
			url: base_url+admin_folder+'forms/browse_texts/file_texts/file_id/'
			,params: {id:fileId, locale:l.get('locale_code')}
	        ,method:'GET'
	        ,waitMsg:'Loading'
		});

		langTabPanel.add(form);
	});

	langTabPanel.setActiveTab(0);
	
	var panel = new Ext.Panel({
		id: 'filePanel_'+fileId
		,title: 'Edit File: '+fileName
		,iconCls: 'disk_multiple'
		,closable: true
		,border: false
		,items: [
			langTabPanel
		]
		,buttons:[
			{
				text: 'Save'
				,handler: function (){
					localesStore.each(function(l){
						Ext.getCmp('fileForm_'+fileId+'_'+l.get('locale_code')).getForm().submit({
							success:function(form, action) {
								csrf_hash = action.result.csrf_token;
							}     
							,failure:function(form, action) {
								csrf_hash = action.result.csrf_token;
							}
						});
					});
					Ext.Msg.alert('Status','Successful save!');
				}
			}
		]
	});

	adminContentPanel = Ext.getCmp('adminContentPanel');
	adminContentPanel.add(panel);
	adminContentPanel.doLayout();
	adminContentPanel.getLayout().setActiveItem(panel);
	return false;
}