Ext.onReady(function() {

	var admin_id;
	var username;
	var modules;
	var random_string;
	var is_super_admin;

	Ext.Ajax.request({
	    url: base_url+admin_folder+'login/info'
	    ,method: 'GET'
	    ,async: false
	    ,success: function(result,request){
	        var jsonData = Ext.util.JSON.decode(result.responseText);

	        admin_id       = jsonData.admin_id;
	        username       = jsonData.username;
	        modules        = jsonData.modules;
	        random_string  = jsonData.random_string;
	        is_super_admin = parseInt(jsonData.is_super_admin);			    

	        if(is_super_admin){
	        	eastTopBar.add({
					xtype:'button'
					,text:'Upload Files'
					,iconCls: 'add'
					,handler: function() {
						filesUpload(0);
					}
				});
				eastTopBar.doLayout();
			}
	    }
	    ,failure: function(){}
	    ,headers: {
	        'Powered-By': 'Ext'
	    }
	});
					 
    Ext.QuickTips.init();
    Ext.override(Ext.ux.form.LovCombo, {
		beforeBlur: Ext.emptyFn
	});

	tabs = [];

	var root = new Ext.tree.TreeNode({
		text:'Root'
		,expanded: true
	});

	var logout = new Ext.tree.TreeNode({
		text: 'Logout'
		,iconCls: 'logout'
		,leaf: true
	});
	root.appendChild(logout);

	modulesStore = new Ext.data.JsonStore({
		url: base_url+admin_folder+'tables/browse/modules'
		,method: 'POST'
		,root: 'data'
		,idProperty: 'module_id'
		,fields: [
			'module_id'
			,'module'
			,'module_description'
			,'module_icon'
			,'sequence'
		]
		,baseParams: {
			custom_field: 'is_active'
			,custom_value: 1
		}
		,sortInfo: {
		    field: 'sequence'
		    ,direction: 'ASC'
		}
		,autoLoad: true
		,remoteSort: true
		,listeners: {
			load: function(store,records,options){
				store.each(function(m)
				{
					if(is_super_admin || modules.indexOf(m.get('module')) != -1){
						var node = new Ext.tree.TreeNode({
							text: m.get('module_description')
							,iconCls: m.get('module_icon')
							,leaf:true
						});
						root.appendChild(node);
					}
				});
			}
		}
	});

	var tree = new Ext.tree.TreePanel({
		border: false
		,rootVisible: false
		,autoScroll: true
		,listeners: {
			click: function(node, event){
				switch(node.text){
					case "Logout":
						adminLogout();
					break;
					case "Administrators":
						createAdminsGrid();
					break;
					case "Contestants":
						createContestantsGrid();
					break;
					case "Settings":
						createSettingsGrid();
					break;
					case "Site Labels":
						createLabelsGrid();
					break;
					case "Files":
						createFilesGrid();
					break;
				}
			}
		}
	});

	tree.setRootNode(root);

	var north = new Ext.BoxComponent({
        region: 'north'
        ,height: 50
        ,margins: '0 5 10 5'
        ,style: {
        	backgroundColor: '#e8eaec'
		}
        ,autoEl: {
            tag: 'div'
            ,html:'<img src="'+base_url+'assets/admin/images/logo.png" />'
        }
    });

    var imagesPanel = createDataViewPanel(1);
    var filesPanel  = createDataViewPanel(0);

	var filesTabPanel = new Ext.TabPanel({
        activeTab: 0
        ,border: false
        ,items: [
        	imagesPanel
        	,filesPanel
        ]
    });

	var eastTopBar = new Ext.Toolbar();

	var east = new Ext.Panel({
		title: 'Files'
		,region: 'east'
		,margins: '0 5'
		,style: {
			backgroundColor: '#ffffff'
		}
        ,width: 598
        ,collapsible: true
        ,layout: 'fit'
        ,tbar: eastTopBar   
		,items: [
			filesTabPanel
		]
	});

    var west = new Ext.Panel({
		id:'adminMenuPanel'
		,title: 'Administration Menu'
		,region: 'west'
		,margins: '0 5'
        ,width: 200
        ,collapsible: true
        ,style: {
			backgroundColor: '#ffffff'
		}
		,items: [tree]
	});

	var center = new Ext.TabPanel({                
		id:'adminContentPanel'
		,autoScroll: true
		,enableTabScroll: true
		,region: 'center'
		,items: []
	});

	var wrapperPanel = new Ext.Panel({
		id: 'wrapperPanel'
		,border: false
		,style: {
			backgroundColor: '#e8eaec'
			,padding: '10px'
		}
		,layout:'border'
		,items: [north,west,east,center]
	});

	if (top === self){
        var viewport = new Ext.Viewport({
			layout: 'fit'
			,items: [wrapperPanel]
		});
    }
});