function createLabelsForm(labelId,labelName){
	
	var langTabPanel = new Ext.TabPanel({
        border: false
		,deferredRender:false
		,items: []
	});
	
	localesStore.each(function(l)
	{
		form = new Ext.FormPanel({
			id: 'labelForm_'+labelId+'_'+l.get('locale_code')
			,title: l.get('locale_description')
			,url: base_url+admin_folder+'forms/submit_texts/label_texts/label_id/'
			,autoHeight: true
			,labelWidth: 150
			,bodyStyle: 'margin-top:5px;'
			,items:[
				{
					xtype: 'hidden'
					,name: 'id'
					,value: labelId
				}
				,{
					xtype: 'hidden'
					,name: 'locale'
					,value: l.get('locale_code')
				}
				,{
					xtype: 'hidden'
					,name: 'parameters'
					,value: 'label_value'
				}
				,{
					xtype: 'textarea'
					,fieldLabel: 'Value'
					,anchor: '100%'
					,height: 500
					,name: 'label_value'
				}
			]
	    });

	    form.load({
			url: base_url+admin_folder+'forms/browse_texts/label_texts/label_id/'
			,params: {id:labelId, locale:l.get('locale_code')}
	        ,method:'GET'
	        ,waitMsg:'Loading'
		});

		langTabPanel.add(form);
	});

	langTabPanel.setActiveTab(0);

	var bottomPanel = new Ext.Panel({
		title: 'Languages'
		,autoHeight: true
		,border: false
		,items: [langTabPanel]
	});

	// var mainImagePanel = createImagePanel('main_image','labels','label_id',labelId);

	var form = new Ext.FormPanel({
		title: 'Basic'
		,autoHeight: true
		,border: false
		,labelWidth: 150
		,flex: 1
		,margins: '0 5 0 0'
		,url: base_url+admin_folder+'forms/submit/labels/label_id/'
		,items: [
			{
				xtype: 'hidden'
				,name: 'id'
				,value: labelId
			}
			,{
				xtype: 'hidden'
				,name: 'parameters'
				,value: 'label_name,label_description'
			}
			,{
				xtype: 'textfield'
				,style: 'margin-top:5px;'
				,fieldLabel: 'Name'
				,anchor: '100%'
				,name: 'label_name'
			}
			,{
				xtype: 'textfield'
				,fieldLabel: 'Description'
				,anchor: '100%'
				,name: 'label_description'
			}
		]
    });

	form.load({
		url: base_url+admin_folder+'forms/browse/labels/label_id/'
		,params: {id:labelId}
        ,method:'GET'
        ,waitMsg:'Loading'
	});

	var topPanel = new Ext.Panel({
		autoHeight: true
		,border: false
		,items: [
			{
                layout:'hbox'
                ,border: false
                ,items: [
					form
					// ,mainImagePanel
				]
            }
		]
	});

	var panel = new Ext.Panel({
		id: 'labelPanel_'+labelId
		,title: 'Edit Site Label: '+labelName
		,iconCls: 'font'
		,closable: true
		,border: false
		,layout: 'fit'
		,bodyStyle: 'padding:5px;'
		,items: [
			{
                xtype: 'container'
                ,layout:'anchor'
        		,autoScroll: true
        		,defaults: {
        			anchor: '-22'
        		}
        		,border: false
                ,items: [
					topPanel
					,bottomPanel
				]
            }
		]
		,buttons:[
			{
				text: 'Save'
				,handler: function (){
					form.getForm().submit();
					localesStore.each(function(l){
						Ext.getCmp('labelForm_'+labelId+'_'+l.get('locale_code')).getForm().submit({
							success:function(form, action) {
								csrf_hash = action.result.csrf_token;
							}     
							,failure:function(form, action) {
								csrf_hash = action.result.csrf_token;
							}
						});
					});
					Ext.Msg.alert('Status','Succesful save!');
				}
			}
		]
		,listeners: {
			beforeclose: function(p){}
		}
	});

	adminContentPanel = Ext.getCmp('adminContentPanel');
	adminContentPanel.add(panel);
	adminContentPanel.doLayout();
	adminContentPanel.getLayout().setActiveItem(panel);
	return false;
}