function createSettingsGrid(){

	var tBar = new Ext.Toolbar({});
	var adminActions = [];
	var index = adminAccessStore.findExact('module','settings');
	var moduleActions = adminAccessStore.getAt(index);

	if(is_super_admin || moduleActions.data.module_actions.indexOf('edit') != -1){
		var adminActions = [
			{
				iconCls:'edit'
				,qtip:'EDIT'
			}
		];
	}

	if(is_super_admin || moduleActions.data.module_actions.indexOf('delete') != -1){
		adminActions.push({
			 iconCls:'delete'
			,qtip:'DELETE'
		});
	}
	
	if(is_super_admin || moduleActions.data.module_actions.indexOf('insert') != -1){
		tBar.addItem({
			text:'Add'
			,tooltip:'Add'
			,iconCls:'add'
			,listeners:{
				click:{scope:this, buffer:200, fn:function(btn) {
					form.show(addRecord(grid,emptyRecord), btn.getEl());
				}}
			}
		});
		tBar.doLayout();
	}

	// tBar.addItem({
	// 	text:'Refresh Token'
	// 	,tooltip:'Refresh Token'
	// 	,iconCls:'refresh'
	// 	,listeners:{
	// 		click:{scope:this, buffer:200, fn:function(btn) {
	// 			refreshToken();
	// 		}}
	// 	}
	// });
	// tBar.doLayout();
	
	var form = new Ext.ux.grid.RecordForm({
		 title:'EDIT'
		,iconCls:'edit'
		,columnCount:1
		,ignoreFields:{
			setting_id:true
		}
		,formConfig:{
			 labelWidth:150
			,buttonAlign:'right'
			,bodyStyle:'padding-top:10px'
		}
	});

	var proxy = new Ext.data.HttpProxy({
		method: "POST"	
		,api: {
			read :    base_url+admin_folder+'tables/browse/settings'
			,create : base_url+admin_folder+'tables/create/settings/setting_id'
			,update:  base_url+admin_folder+'tables/update/settings/setting_id'
			,destroy: base_url+admin_folder+'tables/destroy/settings/setting_id'
		}
	});

	var reader = new Ext.data.JsonReader({
		totalProperty: 'total'
		,successProperty: 'success'
		,idProperty: 'setting_id'
		,root: 'data'
	},[
		{name: 'setting_id'}
		,{name: 'setting_name'}
		,{name: 'setting_value'}
	]);

	var emptyRecord = {
		setting_name: ''
		,setting_value: ''
	};

	var writer = new Ext.data.JsonWriter({
		encode: true
		,writeAllFields: false
	});

	var store = new Ext.data.Store({
		paramsAsHash: true
		,remoteSort: true
		,proxy: proxy
		,reader: reader
		,writer: writer
		,baseParams: {
			start:0
			,limit:100
		}
		,sortInfo: {
		    field: 'setting_id'
		    ,direction: 'ASC'
		}
		,autoLoad: true
		,autoSave: true
		,listeners: {
        exception: function (proxy, response, operation) {
            // adminLogout();
            Ext.Msg.alert('Status','Connectivity Problem!');
        }
    }
	});

	var actions = new Ext.ux.grid.RowActions({
		actions: adminActions
		,widthIntercept: Ext.isSafari ? 4 : 2
		,getEditor: Ext.emptyFn
	});

	var columns =  [
		{header: "Setting Name", width: 300, sortable: true, dataIndex: 'setting_name', editor: new Ext.form.TextField({})}
		,{header: "Setting Value", width: 300, sortable: true, dataIndex: 'setting_value', editor: new Ext.form.TextArea({height: 300})}
		,actions
	];

	var paging = new Ext.PagingToolbar({
		pageSize: 100
		,store: store
		,displayInfo: true
		,displayMsg: '{0} - {1} from {2}'
		,emptyMsg: 'No results found'
	});

	var grid = new Ext.grid.GridPanel({
		id: 'settingsGrid'
		,title: 'Settings'
		,frame: false
		,autoScroll: true
		,closable: true
		,iconCls:'cog'
		,plugins: [actions, form]
		,store: store
		,columns : columns
		,tbar: tBar
		,viewConfig: {
			forceFit: true
		}
		,bbar: paging
		,onRowAction:function(grid, record, action, row, col) {
			switch(action) {
				case 'delete':
					deleteRecord(grid,record);
				break;
				case 'edit':
					createSettingsForm(record.data.setting_id,record.data.setting_name)
				break;
				// case 'edit':
				// 	form.show(record, grid.getView().getCell(row, col));
				// break;
			}
		}
	});

	actions.on('action', grid.onRowAction, grid);
	
	adminContentPanel = Ext.getCmp('adminContentPanel');
	adminContentPanel.add(grid);
	adminContentPanel.doLayout();
	adminContentPanel.getLayout().setActiveItem(grid);
	return false;
}