Ext.util.Format.comboRenderer = function(combo){
    return function(value){
        var record = combo.findRecord(combo.valueField, value);
		if(value==0){ret="<span style=\"color:red\">"+value+"</span>";}else{ret=value;}
        return record ? record.get(combo.displayField) : ret;
    }
}

Ext.util.Format.multiComboRenderer = function(combo){  
    return function(value){ 
    	var valueList = [];
    	var findArr = value.split(',');
    	var i, l=findArr.length;
    	for (i=0; i<l; i++) {
    		if (record = combo.findRecord(combo.valueField, findArr[i])) {
    			valueList.push(record.get(combo.displayField));
    		}
    	}
    	return valueList.join(', ');
    }
}

Ext.util.Format.dateRenderer = function(value){
	if(!value || !value.format) return "";
	var dts=value.format('Y-m-d');
	var now=new Date();
	if(value>=now){
		return "<div style='color:red'>"+dts+"</div>";
		}else{
		return "<div style='color:blue'>"+dts+"</div>";
	}
}

Ext.util.Format.dateRenderer2 = function(value){
	if(!value || !value.format) return "";
	var dts=value.format('Y-m-d H:i:s');
	var now=new Date();
	if(value>=now){
		return "<div style='color:red'>"+dts+"</div>";
		}else{
		return "<div style='color:blue'>"+dts+"</div>";
	}
}

function showImg(fileName){
	// return fileName.indexOf('.svg') != -1? '<img src="'+base_url+'assets/uploads/'+fileName+'" width="99" title="'+fileName+'" />' : '<img src="'+base_url+'images/load_version/99/99/'+fileName+'" title="'+fileName+'" />';
	return '<img src="'+base_url+'assets/uploads/'+fileName+'" style="max-width:99px;max-height:99px;" title="'+fileName+'" />';
}

Ext.util.Format.fileRenderer = function(value){
	var array = value.split(',');
	if(array[1] == 1){
		result = showImg(array[0]);
	} else {
		result = '<img src="'+base_url+'assets/admin/images/not_available.png" width="99" />'
	}
	return result;
}

Ext.util.Format.imageRenderer = function(value){
	var result = '<img src="'+base_url+'assets/admin/images/not_available.png" width="99" />';
	if(value){
		result = showImg(value);
	}
	return result;
}

Ext.util.Format.checkboxRenderer = function(value){
	if(value==0){ret="<span style=\"color:red\">No</span>";}else{ret="<span style=\"color:green\">Yes</span>";}
        return ret;
}

Ext.util.Format.scriptRenderer = function(value){
	return (value)? encodeURIComponent(value) : '';
}

Ext.util.Format.careerFileRenderer = function(value){
	return (value)? '<a target="_blank" href="/assets/career/'+value+'">Click to view file</a>' : 'No file supplied';
}