function createAdminsGrid(){

	var tBar = new Ext.Toolbar({});
	var adminActions = [];
	var index = adminAccessStore.findExact('module','admins');
	var moduleActions = adminAccessStore.getAt(index);

	if(is_super_admin || moduleActions.data.module_actions.indexOf('edit') != -1){
		adminActions.push({
			iconCls: 'edit'
			,qtip: 'EDIT'
		});
		adminActions.push({
			iconCls: 'information'
			,qtip: 'ADMIN ACCESS'
		});
	}

	if(is_super_admin || moduleActions.data.module_actions.indexOf('delete') != -1){
		adminActions.push({
			iconCls: 'delete'
			,qtip: 'DELETE'
		});
	}
	
	if(is_super_admin || moduleActions.data.module_actions.indexOf('insert') != -1){
		tBar.add({
			text:'Add'
			,tooltip:'Add'
			,iconCls:'add'
			,listeners:{
				click:{scope:this, buffer:200, fn:function(btn) {
					form.show(addRecord(grid,emptyRecord), btn.getEl());
				}}
			}
		});
	}
	
	var form = new Ext.ux.grid.RecordForm({
		title:'EDIT'
		,iconCls:'edit'
		,columnCount:1
		,ignoreFields:{
			id:true
			,last_ip:true
			,last_login:true
			,created_at:true
		}
		,formConfig:{
			labelWidth:150
			,buttonAlign:'right'
			,bodyStyle:'padding-top:10px'
		}
	});

	var proxy = new Ext.data.HttpProxy({
		method: "POST"	
		,api: {
			read:     base_url+admin_folder+'tables/browse/admins'
			,create:  base_url+admin_folder+'tables/create/admins/id'
			,update:  base_url+admin_folder+'tables/update/admins/id'
			,destroy: base_url+admin_folder+'tables/destroy/admins/id'
		}
	});

	var reader = new Ext.data.JsonReader({
		totalProperty: 'total'
		,successProperty: 'success'
		,idProperty: 'id'
		,root: 'data'
	},[
		{name: 'id'}
		,{name: 'username'}
		,{name: 'password'}
		,{name: 'last_ip'}
		,{name: 'last_login', type: 'date', dateFormat: 'Y-m-d H:i:s'}
		,{name: 'created_at', type: 'date', dateFormat: 'Y-m-d H:i:s'}
		,{name: 'is_super_admin', type:'boolean'}
		,{name: 'is_active', type:'boolean'}
	]);

	var now = new Date();
	now.format('Y-m-d H:i:s');

	var emptyRecord = {
		username: ''
		,password: ''
		,last_ip: ''
		,last_login: ''
		,created_at: now
		,is_super_admin: 0
		,is_active: 0
	};

	var writer = new Ext.data.JsonWriter({
		encode: true
		,writeAllFields: false
	});

	var store = new Ext.data.Store({
		paramsAsHash: true
		,remoteSort: true
		,proxy: proxy
		,reader: reader
		,writer: writer
		,baseParams: {
			start:0
			,limit:100
		}
		,sortInfo: {
		    field: 'created_at'
		    ,direction: 'ASC'
		}
		,autoLoad: true
		,autoSave: true
		,listeners: {
	        exception: function (proxy, response, operation) {
	        	// adminLogout();
                Ext.Msg.alert('Status','Connectivity Problem!');
            }
	    }
	});

	var actions = new Ext.ux.grid.RowActions({
		actions: adminActions
		,widthIntercept:Ext.isSafari ? 4 : 2
		,getEditor:Ext.emptyFn
	});

	var filters = new Ext.ux.grid.GridFilters({
		encode: true
		,local: false
		,filters: [
			{
				type: 'string'
				,dataIndex: 'username'
			},
			{
				type: 'date'
				,dataIndex: 'created_at'
			}
		]
	});

	var passwordField = new Ext.form.TextField({
		allowBlank: false
		,name: 'password'
	    ,validator: function(value){
	    	var score = scorePassword(value);
	    	return (score>80)? true : "Weak Password";
	    }
	});

	var columns =  [
		{header: "Username", width: 100, sortable: true, dataIndex: 'username', editor: new Ext.form.TextField({allowBlank: false})}
		,{header: "Password", width: 100, sortable: true, dataIndex: 'password', editor: passwordField}
		,{header: "Last IP", width: 100, sortable: true, dataIndex: 'last_ip'}
		,{header: "Last Login", width: 100, sortable: true, dataIndex: 'last_login', renderer: Ext.util.Format.dateRenderer2}
		,{header: "Created", width: 100, sortable: true, dataIndex: 'created_at', renderer: Ext.util.Format.dateRenderer2}
		,{header: "Super Admin", width: 50, sortable: true, dataIndex: 'is_super_admin', editor: new Ext.ux.form.XCheckbox(), renderer: Ext.util.Format.checkboxRenderer}
		,{header: "Active", width: 50, sortable: true, dataIndex: 'is_active', editor: new Ext.ux.form.XCheckbox(), renderer: Ext.util.Format.checkboxRenderer}
		,actions
	];

	var paging = new Ext.PagingToolbar({
		pageSize: 100
		,store: store
		,displayInfo: true
		,displayMsg: '{0} - {1} from {2}'
		,emptyMsg: 'No results found'
	});

	var grid = new Ext.grid.GridPanel({
		id: 'adminsGrid'
		,title: 'Administrators'
		,frame: false
		,autoScroll: true
		,closable: true
		,iconCls:'admin'
		,plugins: [actions, form, filters]
		,store: store
		,columns : columns
		,tbar: tBar
		,viewConfig: {
			forceFit: true
		}
		,bbar: paging
		,onRowAction:function(grid, record, action, row, col) {
			switch(action) {
				case 'delete':
					deleteRecord(grid,record);
				break;
				case 'edit':
					form.show(record, grid.getView().getCell(row, col));
				break;
				case 'information':
					createAdminAccessGrid(record.data.id);
				break;
			}
		}
	});

	actions.on('action', grid.onRowAction, grid);
	
	adminContentPanel = Ext.getCmp('adminContentPanel');
	adminContentPanel.add(grid);
	adminContentPanel.doLayout();
	adminContentPanel.getLayout().setActiveItem(grid);
	return false;
}