﻿CKEDITOR.plugins.add( 'cmsLinks',
{
	init: function( editor )
	{
		editor.addCommand( 'cmsLinksDialog', new CKEDITOR.dialogCommand( 'cmsLinksDialog' ) );
 
		editor.ui.addButton( 'cmsLinks',
		{
			label: 'Insert a custom CMS link',
			command: 'cmsLinksDialog',
			icon: this.path + 'images/icon.png'
		} );
 
		CKEDITOR.dialog.add( 'cmsLinksDialog', function( editor )
		{
			return {
				title : 'Link Properties',
				minWidth : 400,
				minHeight : 200,
				contents :
				[
					{
						id : 'general',
						label : 'Settings',
						elements :
						[
							{
								type :  'select',
								id :    'contentTypeIdSelect',
								label : 'Content Type ',
								style:  'width:100%',
								items : [],
								onChange : function()
								{
									var dialog                = this.getDialog();
									var contentIdSelect       = dialog.getContentElement( 'general', 'contentIdSelect' );
									var selectedContentTypeId = parseInt(this.getValue());

									contentIdSelect.clear();
									
									var store = new Ext.data.JsonStore({
										url: '/admin/tables/get_menus/gr'
										,method: 'post'
										,root: 'data'
										,baseParams: { content_type_id: selectedContentTypeId }
										,idProperty: 'content_id'
										,fields: [
											'content_id'
											,'content_text_title'
										]
										,listeners: {
											load: function(store,records,options){
												store.each(function(l)
												{
													contentIdSelect.add(l.get('content_text_title'), l.get('content_id'));
												});
											}
										}
									});

									store.load();
								},
								onLoad: function() {
									var el = this;

									var store = new Ext.data.JsonStore({
										url: '/admin/tables/browse/content_types'
										,method: 'post'
										,baseParams: {
											custom_field: 'is_sitemap'
											,custom_value: 1
										}
										,root: 'data'
										,idProperty: 'content_type_id'
										,fields: [
											'content_type_id'
											,'content_type_description'
										]
										,listeners: {
											load: function(store,records,options){
												store.each(function(l)
												{
													el.add(l.get('content_type_description'), l.get('content_type_id'));
												});
											}
										}
									});

									store.load();
			                    },
								commit : function( data )
								{
									data.contentTypeId = this.getValue();
								}
							},
							{
								type :  'select',
								id :    'contentIdSelect',
								label : 'Specific Content',
								style:  'width:100%',
								items : [],
								commit : function( data )
								{
									data.contentId = this.getValue();
								}
							},
							{
								type :  'select',
								id :    'targetType',
								label : 'Target',
								style:  'width:100%',
								items : 
								[
									['SELF','_self']
									,['BLANK','_blank']
									,['PARENT','_parent']
									,['TOP','_top']
								],
								commit : function( data )
								{
									data.targetType = this.getValue();
								}
							},
							{
								type :  'checkbox',
								id :    'popupPage',
								label : 'is Popup',
								'default' : true,
								commit : function( data )
								{
									data.popupPage = this.getValue();
								}
							}
						]
					}
				],
				onOk : function()
				{
					var txt = editor.getSelection().getNative();
					// console.log(txt);

					var editorId = editor.element.$.id;
					var locale = editorId.split('_').pop();

					var dialog = this,
						data = {},
						link = editor.document.createElement( 'a' );

					this.commitContent( data );

					link.setAttribute( 'target', data.targetType );
					if ( data.popupPage )
						link.setAttribute( 'class', 'fancybox' );

					Ext.Ajax.request({
						url: '/administration/make_url'
						,params:{
							locale: locale
							,content_type_id: data.contentTypeId 
							,content_id: data.contentId 
						}
						,method: 'POST'
						,success: function(result,request){
							var jsonData = Ext.util.JSON.decode(result.responseText);
							link.setAttribute( 'href', jsonData.friendly_url );
						}
						,failure: function(){}
						,headers: {
							'Powered-By': 'Ext'
						}
					});	

					link.setHtml( txt );
					editor.insertElement( link );
				}
			};
		});
	}
});