function clearFormErrors(form){
    form.find('.has-error').removeClass('has-error');
    form.find('.message, .error').empty();
    return false;
}
function fieldErrors(form,errorsArray){
    if(typeof(errorsArray) !== 'undefined'){
        for(var i=0;i<errorsArray.length;i++) {
            var field = form.find('[name="'+errorsArray[i].name+'"]'),
                error = errorsArray[i].text;
            if(error.length && field.length) {
                field.parents('.input-error-wrapper').addClass('has-error');
                field.parents('.input-error-wrapper').find('.error').html(error)
            }
        };
    }
    return false;
}

function showMessage(message,wait){
    var popup = null;
    if(message){
        popup = $.fancybox.open('<div class="message">'+message+'</div>');
        if(wait>0){
            setTimeout(function(){
                popup.close(true);
            },wait);
        }
    }
    return popup;
}
// Size the parent iFrame
function iframeResize() {
    var height = $('body').outerHeight(); // IMPORTANT: If body's height is set to 100% with CSS this will not work.
    parent.postMessage("resize::"+height,"*");
}
(function($) {
    setInterval(iframeResize, 200);

    $(document).on('submit', '.default-form', function(e) {
        e.preventDefault();
        var form         = $(this),
            submitBtn    = form.find('[type="submit"]'),
            hasRecaptcha = form.hasClass('has-recaptcha'),
            clearFields  = form.hasClass('clear-fields'),
            innerMessage = form.hasClass('show-inner-message'),
            csrfToken    = $('input[name="csrf_token"]').val();

        submitBtn.prop('disabled',true);
        clearFormErrors(form);

        $.post(form.attr('action'), form.serialize()+'&csrf_token='+csrfToken, function(response){
            submitBtn.prop('disabled',false);
            if(hasRecaptcha){
                grecaptcha.reset();
            }
            if(response.message){
                if(innerMessage){
                    if(response.success == true){
                        form.find('.message').html('<div class="success-message">'+response.message+'</div>');
                    } else {
                        form.find('.message').html('<div class="error-message">'+response.message+'</div>');
                    }
                } else {
                    showPopupMessage(response.message,response.wait);
                }
            }
            if(response.success == true){
                if(clearFields){
                    form.find('[type="text"]').val('').attr('data-empty', 'true');
                    form.find('[type="checkbox"]').prop('checked',false);
                }
                if(response.redirect_url && response.wait){
                    setTimeout(function(){ 
                        window.location.href = response.redirect_url;
                    }, response.wait);
                }
            } else {
                fieldErrors(form,response.field_errors);
            }
        },"json");
        return false;
    });
})(jQuery);