<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Admins_model extends CI_Model
{
	function __construct()
	{
		parent::__construct();
		
	}

	function get_admin_by_random_string()
	{
		$query = $this->db->query('Select * From admins Where random_string = ? And id = ?',array((string)$this->session->userdata('random_string'),(int)$this->session->userdata('admin_id')));
		return ($query->num_rows()==0)? FALSE : TRUE;
	}

	function password_strength($password)
	{
	    $result = array(
	    	'success'  => TRUE
	    	,'message' => ''
	    );
	    if (strlen($password) < 8) {
	    	$result['success']  = FALSE;
	    	$result['message'] += '<p>Password too short!</p>';
	    }
	    if (!preg_match("#[0-9]+#", $password)) {
	    	$result['success']  = FALSE;
	    	$result['message'] += '<p>Password must include at least one number!</p>';
	    }
	    if (!preg_match("#[a-zA-Z]+#", $password)) {
	    	$result['success']  = FALSE;
	    	$result['message'] += '<p>Password must include at least one letter!</p>';
	    }     
	    return $result;
	}

	function username_unique($username,$id)
	{
		$query = $this->db->query('Select * From admins Where LOWER(username) = ? And id <> ?',array(strtolower($username),$id));
		return $query->num_rows() ? FALSE : TRUE;
	}

	function get_admin($username)
	{
		$query = $this->db->query('Select * From admins Where LOWER(username) = ? And is_active = 1',array(strtolower($username)));
		if ($query->num_rows() == 1)
		{
			$admin = $query->row();
			$query = $this->db->query('Select module From admin_access Where admin_id = ?',array($admin->id));
			$modules_arr = array();
			$modules = $query->result_array();
			foreach ($modules as $m) 
			{
				$modules_arr[] = $m['module'];
			}
			$admin->modules = implode(',', $modules_arr);
			return $admin;
		}  
		return NULL;
	}

	function login($username,$password)
	{
		if ((strlen($username) > 0) AND (strlen($password) > 0)) 
		{
			if (!is_null($admin = $this->admins_model->get_admin($username))) 
			{
				if($this->encryption->decrypt($admin->password)==$password) 
				{
					$this->session->set_userdata(array(
						'admin_id'	      => $admin->id
						,'random_string'  => $admin->random_string
						,'username'	      => $admin->username
						,'is_super_admin' => $admin->is_super_admin
						,'modules'	      => $admin->modules
					));
					$this->session->sess_regenerate();

					$this->admins_model->update_login_info($admin->id);
					message_handler(TRUE,'Login Successful');
				} 
				else 
				{														
					message_handler(FALSE,'Wrong Credentials');
				}
			} 
			else 
			{
				message_handler(FALSE,'Wrong Credentials');
			}
		}
		else
		{
			message_handler(FALSE,'Wrong Credentials');
		}
		return TRUE;
	}

	function logout()
	{
		$this->db->query('Update admins Set random_string = ? Where admin_id = ?',array(generate_random_string(20),$this->session->userdata('admin_id')));

		$this->session->unset_userdata(array('admin_id', 'random_string', 'username', 'is_super_admin', 'modules'));
		$this->session->sess_regenerate();
		return TRUE;
	}

	function has_access($table,$action)
	{
		if($this->session->userdata('is_super_admin'))
		{
			return TRUE;
		}
		else
		{
			$combo_tables = array('locales','modules','admin_access','menu_types','content_types','files','galleries');
			$admin_tables = array();

			if($table)
			{
				// COMBOBOX STORES
				if((in_array($table, $combo_tables)) && ($action=='browse') && $this->session->userdata('admin_id'))
				{
					return TRUE;
				}


				$modules_arr = explode(',', $this->session->userdata('modules'));
				foreach ($modules_arr as $m)
				{
					$query = $this->db->query('Select module,tables From modules Where module = ?',array($m));
					if($query->num_rows() == 1)
					{
						$admin_tables[] = $query->row_array();
					}	
				}

				$has_tables = FALSE;
				$module     = '';
				foreach ($admin_tables as $at)
				{
					if(strpos($at['tables'], $table) !== FALSE)
					{
						$has_tables = TRUE;
						$module     = $at['module'];
					}

				}

				if($has_tables && $module)
				{
					$query = $this->db->query('Select module_actions from admin_access Where module = ? And admin_id = ?',array($module,$this->session->userdata('admin_id')));
					if($query->num_rows() == 1)
					{
						$ma = $query->row_array();
						if(strpos($ma['module_actions'], $action) !== FALSE)
						{
							return TRUE;
						}
						else 
						{
							return FALSE;
						}
					}
					else 
					{
						return FALSE;
					}
				}
				else
				{
					return FALSE;
				}
			} 
			else
			{
				return ($this->session->userdata('admin_id')) ? TRUE : FALSE;
			}
		}
	}

	function update_login_info($admin_id)
	{
		$query = $this->db->query('Update admins Set last_ip = ?, last_login = ? Where id = ?',array($this->input->ip_address(),date('Y-m-d H:i:s'),$admin_id));
	}
}

/* End of file admins_model.php */
/* Location: ./application/models/admins_model.php */