function createFilesGrid(locale){

	var tBar = new Ext.Toolbar({});
	var adminActions = [];
	var index = adminAccessStore.findExact('module','files');
	var moduleActions = adminAccessStore.getAt(index);

	if(is_super_admin || moduleActions.data.module_actions.indexOf('insert') != -1){
		tBar.add({
			xtype:'button'
			,text:'Upload Files'
			,iconCls: 'add'
			,handler: function() {
				filesUpload(0);
			}
		});
	}

	if(is_super_admin || moduleActions.data.module_actions.indexOf('edit') != -1){
		adminActions.push({
			iconCls: 'edit'
			,qtip: 'EDIT'
		});
	}

	if(is_super_admin || moduleActions.data.module_actions.indexOf('delete') != -1){
		adminActions.push({
			iconCls: 'delete'
			,qtip: 'DELETE'
		});
		tBar.add({
			xtype:'button'
			,text: 'Delete Selected Files'
			,iconCls:'delete'
			,handler: function() {
				massDeleteFiles();
			}
		});
	}

	var store = new Ext.data.JsonStore({
		id: 'filesStore'
		,url: base_url+admin_folder+'tables/browse_locale/files/file_texts/file_id/'+admin_locale
		,autoLoad: true
		,paramsAsHash: true
		,remoteSort: true
		,method: 'POST'
		,baseParams: {
			select_fields: 'files.file_id,file_name,file_type,file_size,is_image,image_width,image_height,created_at'
			,start: 0
			,limit: 100
		}
		,sortInfo: {
		    field: 'created_at'
		    ,direction: 'DESC'
		}
		,root: 'data'
		,totalProperty: 'total'
		,successProperty: 'success'
		,idProperty: 'file_id'
		,fields: 
		[
			{name: 'file_id'}
			,{name: 'file_name'}
			,{name: 'file_type'}
			,{name: 'file_size'}
			,{name: 'is_image'}
			,{name: 'image_width'}
			,{name: 'image_height'}
			,{name: 'created_at', type:'date', dateFormat:'Y-m-d H:i:s'}
			,{name: 'file_preview', mapping: 'file_name + "," + obj.is_image'}
		]
		,listeners: {
	        exception: function (proxy, response, operation) {
	            // adminLogout();
                Ext.Msg.alert('Status','Connectivity Problem!');
	        }
	    }
	});

	var actions = new Ext.ux.grid.RowActions({
		actions: adminActions
		,widthIntercept: Ext.isSafari ? 4 : 2
		,getEditor: Ext.emptyFn
	});
	
	var filters = new Ext.ux.grid.GridFilters({
		local: true
		,filters: [
			{
				type: 'string'
				,dataIndex: 'file_type'
			}
			,{
				type: 'string'
				,dataIndex: 'file_name'
			}
			,{
				type: 'boolean'
				,dataIndex: 'is_image'
			}
		]
	});

	var columns =  [
		{header: "File Preview", width: 100, sortable: true, dataIndex: 'file_preview', renderer:Ext.util.Format.fileRenderer}
		,{header: "File Name", width: 100, sortable: true, dataIndex: 'file_name'}
		,{header: "File Type", width: 100, sortable: true, dataIndex: 'file_type'}
		,{header: "File Size", width: 100, sortable: true, dataIndex: 'file_size'}
		,{header: "Is Image", width: 100, sortable: true, dataIndex: 'is_image',renderer:Ext.util.Format.checkboxRenderer}
		,{header: "Image Width", width: 100, sortable: true, dataIndex: 'image_width'}
		,{header: "Image Height", width: 100, sortable: true, dataIndex: 'image_height'}
		,{header: "Created", width: 100, sortable: true, editor: new Ext.form.DateField({format:"Y-m-d H:i:s"}), dataIndex: 'created_at' ,renderer:Ext.util.Format.dateRenderer2}
		,actions
	];

	var paging = new Ext.PagingToolbar({
		pageSize: 100
		,store: store
		,displayInfo: true
		,displayMsg: '{0} - {1} from {2}'
		,emptyMsg: 'No results found'
	});

	var grid = new Ext.grid.GridPanel({
		id: 'filesGrid'
		,title: 'Files'
		,iconCls: 'disk_multiple'
		,ddGroup: 'group'
	    ,enableDragDrop: true
		,closable: true
		,frame: false
		,autoScroll: true
		,plugins: [actions,filters]
		,store: store
		,columns : columns
		// ,sm: new Ext.grid.RowSelectionModel({
		// 	singleSelect: true
		// })
		,tbar: tBar
		,viewConfig: {
			forceFit: true
		}
		,bbar: paging
		,onRowAction:function(grid, record, action, row, col) {
			switch(action) {
				case 'delete':
					deleteFile(grid,record.data.file_id);
				break;
				case 'edit':
					createFilesForm(record.data.file_id,record.data.file_name);
				break;
			}
		}
	}); 

	actions.on('action', grid.onRowAction, grid);
	
	adminContentPanel = Ext.getCmp('adminContentPanel');
	adminContentPanel.add(grid);
	adminContentPanel.doLayout();
	adminContentPanel.getLayout().setActiveItem(grid);
	return false;
}